/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.trident;

import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.CustomObject;
import com.filenet.wcm.api.Document;
import com.filenet.wcm.api.Folder;
import com.filenet.wcm.api.GettableObject;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.ReadableMetadataObject;
import com.filenet.wcm.api.StoredSearch;
import com.filenet.wcm.api.TransportInputStream;
import com.filenet.wcm.api.VersionSeries;
import com.filenet.wcm.apps.server.util.prefs.WcmObjectStorePrefs;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import filenet.vw.api.VWException;
import filenet.vw.idm.toolkit.IVWIDMDocClass;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMFolder;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.IVWIDMLibrary;
import filenet.vw.idm.toolkit.IVWIDMLink;
import filenet.vw.idm.toolkit.IVWIDMPropertyDescription;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.idm.trident.VWIDMTridentCustomObject;
import filenet.vw.idm.trident.VWIDMTridentDocClass;
import filenet.vw.idm.trident.VWIDMTridentDocument;
import filenet.vw.idm.trident.VWIDMTridentFolder;
import filenet.vw.idm.trident.VWIDMTridentItem;
import filenet.vw.idm.trident.VWIDMTridentPropertyDescription;
import filenet.vw.idm.trident.VWIDMTridentStoredSearch;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Hashtable;

public final class VWIDMTridentLibrary
extends VWIDMTridentItem
implements IVWIDMLibrary {
    ObjectStore m_wcmLib = null;
    IVWIDMDocClass[] m_docClasses = null;
    private static final String m_className = "VWIDMTridentLibrary";
    private String m_documentNameProperty = null;
    private String m_folderNameProperty = null;
    private String m_customObjectNameProperty = null;

    protected VWIDMTridentLibrary(ObjectStore lib) {
        this.m_lib = this;
        this.m_wcmObject = lib;
        this.m_wcmLib = lib;
        this.m_id = this.m_wcmObject.getId();
        this.m_labelPropName = "DisplayName";
    }

    protected VWIDMTridentLibrary(ObjectStore lib, WcmDlgItem dlgItem) {
        this.m_lib = this;
        this.m_wcmObject = lib;
        this.m_wcmLib = lib;
        this.m_id = this.m_wcmObject.getId();
        this.m_dlgItem = dlgItem;
        this.m_labelPropName = "DisplayName";
    }

    public String getLibraryId() {
        return this.m_id;
    }

    public String getLibraryLabel() {
        return this.m_label;
    }

    public String getCanonicalName() {
        String s = Integer.toString(1) + ":" + Integer.toString(3) + ":" + this.m_id;
        logger.exiting(m_className, "getCanonicalName", s);
        return s;
    }

    protected void initContents() throws VWException {
        if (this.m_wcmLib == null) {
            throw new VWException("idm.trident.IDMTridentLibrary.getProp1", "No object is available.");
        }
        String m_method = "initContents";
        try {
            Folder rootFolder = this.m_wcmLib.getRootFolder();
            if (rootFolder != null) {
                VWIDMTridentFolder idmRootFolder = new VWIDMTridentFolder(rootFolder, this);
                this.m_contents = (VWIDMTridentItem[])idmRootFolder.list(true);
                idmRootFolder.clearContents();
                Object var3_4 = null;
            }
        }
        catch (Exception e) {
            throw new VWException("idm.trident.IDMTridentLibrary.initContents", "Exception: {0}", e.getMessage());
        }
    }

    public Object getProp(String propName) throws VWException {
        if (this.m_wcmLib == null) {
            throw new VWException("idm.trident.IDMTridentLibrary.getProp1", "No object is available.");
        }
        String m_method = "getProp:" + propName;
        try {
            Object retVal = null;
            Properties props = this.m_wcmLib.getProperties(new String[]{propName});
            if (props != null) {
                Property prop = (Property)props.get(0);
                retVal = VWIDMTridentItem.mapGetPropertyValue(prop.getValue(), propName, prop);
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "value=" + (retVal == null ? "NULL" : retVal.toString()));
            }
            return retVal;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.IDMTridentLibrary.getProp.svr", "Failed to get property {0}.  {1}", propName, e.getMessage());
        }
    }

    public void setProp(String propName, Object propVal) throws VWException {
        throw new VWException("idm.trident.IDMTridentLibrary.invalidFunction", "Invalid function");
    }

    public void save() throws VWException {
        throw new VWException("idm.trident.IDMTridentLibrary.invalidFunction", "Invalid function");
    }

    public int getType() {
        return 1;
    }

    /*
     * Loose catch block
     */
    public IVWIDMDocument createDocument(String docClass, IVWIDMFolder filedInFolder, String fileName, String[] propNames, Object[] propVals, String[] granteeNames, int[] granteeTypes, int[] granteeAccesses, byte[] docContents) throws VWException {
        VWIDMTridentDocument vWIDMTridentDocument;
        TransportInputStream t;
        String m_method;
        block16: {
            m_method = "createDocument:" + docClass;
            logger.entering(m_className, m_method);
            t = null;
            Folder docFolder = ((VWIDMTridentFolder)filedInFolder).getCEFolder();
            Properties ps = ObjectFactory.getProperties();
            String mimeType = null;
            if (propNames != null && propVals != null) {
                int len = propNames.length;
                int vLen = propVals.length;
                for (int i = 0; i < len && i < vLen; ++i) {
                    if (propVals[i] == null) continue;
                    if (mimeType == null && propNames[i].equals("MimeType")) {
                        mimeType = (String)propVals[i];
                    }
                    ps.add((Object)VWIDMTridentItem.getCEPropertyWithVal(propNames[i], propVals[i]));
                }
            } else {
                Property p = ObjectFactory.getProperty((String)"DocumentTitle");
                p.setValue("DOC_" + new Date().toString());
                ps.add((Object)p);
            }
            if (mimeType == null) {
                mimeType = "application/binary";
            }
            Document d = (Document)this.m_wcmLib.createObject(docClass, ps, null);
            t = new TransportInputStream((InputStream)new ByteArrayInputStream(docContents));
            t.setMimeType(mimeType);
            t.setFilename(fileName);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "setting document contents..");
            }
            d.setContent(t, true, false);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "filing document to Folder:" + docFolder.getId());
            }
            String containmentName = d.file(docFolder, true);
            String folderPath = null;
            folderPath = docFolder.getPropertyStringValue("PathName");
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Document filed as " + folderPath + "/" + containmentName);
            }
            vWIDMTridentDocument = new VWIDMTridentDocument(d, this);
            Object var20_24 = null;
            if (t == null) break block16;
            try {
                t.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        logger.exiting(m_className, m_method);
        return vWIDMTridentDocument;
        catch (Exception e) {
            try {
                logger.throwing(m_className, m_method, e);
                throw new VWException(e);
            }
            catch (Throwable throwable) {
                Object var20_25 = null;
                if (t != null) {
                    try {
                        t.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public IVWIDMDocument createDocumentFromStream(String docClass, IVWIDMFolder filedInFolder, String fileName, String[] propNames, Object[] propVals, String[] granteeNames, int[] granteeTypes, int[] granteeAccesses, InputStream in) throws VWException {
        VWIDMTridentDocument vWIDMTridentDocument;
        TransportInputStream t;
        String m_method;
        block16: {
            m_method = "createDocumentFromStream:" + docClass;
            logger.entering(m_className, m_method);
            t = null;
            Folder docFolder = ((VWIDMTridentFolder)filedInFolder).getCEFolder();
            Properties ps = ObjectFactory.getProperties();
            String mimeType = null;
            if (propNames != null && propVals != null) {
                int len = propNames.length;
                int vLen = propVals.length;
                for (int i = 0; i < len && i < vLen; ++i) {
                    if (propVals[i] == null) continue;
                    if (mimeType == null && propNames[i].equals("MimeType")) {
                        mimeType = (String)propVals[i];
                    }
                    ps.add((Object)VWIDMTridentItem.getCEPropertyWithVal(propNames[i], propVals[i]));
                }
            } else {
                Property p = ObjectFactory.getProperty((String)"DocumentTitle");
                p.setValue("DOC_" + new Date().toString());
                ps.add((Object)p);
            }
            if (mimeType == null) {
                mimeType = "application/binary";
            }
            Document d = (Document)this.m_wcmLib.createObject(docClass, ps, null);
            t = new TransportInputStream(in);
            t.setMimeType(mimeType);
            t.setFilename(fileName);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "setting document contents..");
            }
            d.setContent(t, true, false);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "filing document to Folder:" + docFolder.getId());
            }
            String containmentName = d.file(docFolder, true);
            String folderPath = null;
            folderPath = docFolder.getPropertyStringValue("PathName");
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Document filed as " + folderPath + "/" + containmentName);
            }
            vWIDMTridentDocument = new VWIDMTridentDocument(d, this);
            Object var20_24 = null;
            if (t == null) break block16;
            try {
                t.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        logger.exiting(m_className, m_method);
        return vWIDMTridentDocument;
        catch (Exception e) {
            try {
                logger.throwing(m_className, m_method, e);
                throw new VWException(e);
            }
            catch (Throwable throwable) {
                Object var20_25 = null;
                if (t != null) {
                    try {
                        t.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    private GettableObject getObject(int objectType, String guidOrPath) throws Exception {
        if (this.m_wcmLib == null) {
            throw new VWException("idm.trident.IDMTridentLibrary.noLibraryObj", "null library object pointer.");
        }
        GettableObject obj = this.m_wcmLib.getObject(objectType, guidOrPath);
        obj.getName();
        return obj;
    }

    public IVWIDMDocClass getDocClass(String docClass) throws VWException {
        String m_method = "getDocClass:" + docClass;
        try {
            logger.entering(m_className, m_method);
            VWIDMTridentDocClass vWIDMTridentDocClass = new VWIDMTridentDocClass((ClassDescription)this.getObject(25, docClass), this);
            Object var5_5 = null;
            logger.exiting(m_className, m_method);
            return vWIDMTridentDocClass;
        }
        catch (Exception e) {
            try {
                logger.throwing(m_className, m_method, e);
                throw new VWException("idm.trident.IDMTridentLibrary.getDocClass", "Failed to get document class {0}. {1}", docClass, e.getMessage());
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    public IVWIDMDocClass[] docClasses() throws VWException {
        try {
            if (this.m_docClasses == null) {
                this.m_docClasses = VWIDMTridentDocClass.fromClassDescriptions(this.m_wcmLib.getClassDescriptions(new int[]{1}), this);
            }
            return this.m_docClasses;
        }
        catch (Exception e) {
            throw new VWException("idm.trident.IDMTridentLibrary.getDocClasses", "Failed to get document classes.  {0}", e.getMessage());
        }
    }

    public IVWIDMDocument getDocument(String id) throws VWException {
        String m_method = "getDocument:" + id;
        try {
            logger.entering(m_className, m_method);
            return new VWIDMTridentDocument((Document)this.getObject(1, id), this);
        }
        catch (Exception e) {
            throw new VWException("idm.trident.IDMTridentLibrary.getDocument.FailedWithId", "Failed to get document id={0}. {1}", id, e.getMessage());
        }
    }

    public IVWIDMFolder getFolder(String id) throws VWException {
        String m_method = "getFolder:" + id;
        try {
            logger.entering(m_className, m_method);
            return new VWIDMTridentFolder((Folder)this.getObject(2, id), this);
        }
        catch (Exception e) {
            throw new VWException("idm.trident.IDMTridentLibrary.getFolder", "Failed to get folder {0}. {1}", id, e.getMessage());
        }
    }

    public IVWIDMItem getStoredSearch(String id) throws VWException {
        String m_method = "getStoredSearch:" + id;
        try {
            logger.entering(m_className, m_method);
            return new VWIDMTridentStoredSearch((StoredSearch)this.getObject(-100, id), this);
        }
        catch (Exception e) {
            throw new VWException("idm.trident.IDMTridentLibrary.getStoredSearch.FailedWithId", "Failed to get stored search with id ={0}. {1}", id, e.getMessage());
        }
    }

    public IVWIDMItem getCustomObject(String id) throws VWException {
        String m_method = "getCustomObject:" + id;
        try {
            logger.entering(m_className, m_method);
            return new VWIDMTridentCustomObject((CustomObject)this.getObject(15, id), this);
        }
        catch (Exception e) {
            throw new VWException("idm.trident.IDMTridentLibrary.getCustomObject", "Failed to get custom object {0}. {1}", id, e.getMessage());
        }
    }

    public IVWIDMItem getStoredSearch(String versionSeriesId, String version) throws VWException {
        String m_method = "getStoredSearch";
        try {
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "vsId=" + (versionSeriesId == null ? "NULL" : versionSeriesId) + ",version=" + (version == null ? "NULL" : version));
            }
            StoredSearch srch = null;
            if (version != null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "calling ObjectStore.getObject(DOC):" + version);
                }
                srch = (StoredSearch)this.getObject(-100, version);
            }
            if (versionSeriesId != null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "getting the VersionSeries object with id=" + versionSeriesId);
                }
                VersionSeries ver = (VersionSeries)this.getObject(1140, versionSeriesId);
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "got the VersionSeries, wrap the Docuemnt obj..");
                }
                return new VWIDMTridentStoredSearch(ver, srch, this);
            }
            if (srch == null) {
                throw new VWException("idm.trident.IDMTridentLibrary.getStoredSearch.NoId", "No id was provided.");
            }
            return new VWIDMTridentStoredSearch(srch, this);
        }
        catch (VWException vwe) {
            throw vwe;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.IDMTridentLibrary.getStoredSearch.FailedWithVerId", "Failed to get stored search with version Series Id = {0}. {1}", versionSeriesId, e.getMessage());
        }
    }

    public String getActiveUser() throws VWException {
        return null;
    }

    public String[] getUsers() throws VWException {
        return null;
    }

    public String[] getGroups() throws VWException {
        return null;
    }

    public boolean hasWorkflowLinkSupport() {
        return false;
    }

    public boolean canCreateWorkflowLinkForDocClass(String docClass, String WfDocID) throws VWException {
        return false;
    }

    public boolean canCreateWorkflowLinkForDocID(String docID, String WfDocID) throws VWException {
        return false;
    }

    public IVWIDMLink createWorkflowLink(String docClass, String docID, String name, String subject, String wfDefDocID, String wfTitle, int eventType, String expression) throws VWException {
        return null;
    }

    public IVWIDMLink[] getWorkflowLinks(String docClass, String docID, String wfDefID, int eventType, int isolatedRegion) throws VWException {
        return null;
    }

    public String toString() {
        return Integer.toString(this.m_libType) + ":" + this.m_id;
    }

    public boolean isLoggedOn() {
        return true;
    }

    public void logon(String name, String pw, String group) throws VWException {
        throw new VWException("idm.trident.IDMTridentLibrary.invalidFunction", "Invalid function");
    }

    public void logonWithToken(String token) throws VWException {
        throw new VWException("idm.trident.IDMTridentLibrary.invalidFunction", "Invalid function");
    }

    public void logoff() throws VWException {
        throw new VWException("idm.trident.IDMTridentLibrary.invalidFunction", "Invalid function");
    }

    public IVWIDMItem[] performQuery(Hashtable querySpecification) throws VWException {
        throw new VWException("idm.trident.IDMTridentLibrary.invalidFunction", "Invalid function");
    }

    private int mapObjType(int objType) {
        switch (objType) {
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return -100;
            }
        }
        return objType;
    }

    public IVWIDMPropertyDescription[] getPropertyDescriptions(int objType) throws VWException {
        try {
            int[] types = new int[]{this.mapObjType(objType)};
            return VWIDMTridentPropertyDescription.fromPropertyDescriptions(this.m_wcmLib.getPropertyDescriptions(types), this);
        }
        catch (Exception e) {
            throw new VWException("idm.trident.IDMTridentLibrary.getPropertyDescriptions", "Failed to get property descriptions. {0}", e.getMessage());
        }
    }

    public void initForLinking(String vwRouterURL, String name, String pw, String token) throws VWException {
        throw new VWException("idm.trident.IDMTridentLibrary.invalidFunction", "Invalid function");
    }

    public IVWIDMDocument getDocument(String versionSeriesId, String version) throws VWException {
        String m_method = "getDocument";
        try {
            boolean wantReleased;
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "vsId=" + (versionSeriesId == null ? "NULL" : versionSeriesId) + ",version=" + (version == null ? "NULL" : version));
            }
            Document doc = null;
            boolean wantCurrent = version == null;
            boolean bl = wantReleased = version != null && version.equals("-1");
            if (!wantCurrent && !wantReleased) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "calling ObjectStore.getObject(DOC):" + version);
                }
                doc = (Document)this.getObject(1, version);
            }
            if (versionSeriesId != null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "getting the VersionSeries object with id=" + versionSeriesId);
                }
                VersionSeries ver = (VersionSeries)this.getObject(1140, versionSeriesId);
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "got the VersionSeries, wrap the Docuemnt obj..");
                }
                return new VWIDMTridentDocument(ver, doc, this, wantCurrent, wantReleased);
            }
            if (doc == null) {
                throw new VWException("idm.trident.IDMTridentLibrary.getDocument.NoDocId", "No document id was provided.");
            }
            return new VWIDMTridentDocument(doc, this);
        }
        catch (VWException vwe) {
            throw vwe;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.IDMTridentLibrary.getDocument.FailedWithVerId", "Failed to get document with version Series Id = {0}. {1}", versionSeriesId, e.getMessage());
        }
    }

    protected ReadableMetadataObject getBrightspireObject(String id, int wcmObjType) throws Exception {
        logger.entering(m_className, "getBrightspireObject, id=" + id + ", type=" + Integer.toString(wcmObjType));
        return (ReadableMetadataObject)this.getObject(wcmObjType, id);
    }

    protected String getDocumentNameProperty() {
        String method = "getDocumentNameProperty:" + this.getLabel();
        if (this.m_documentNameProperty == null) {
            try {
                WcmSitePrefs sitePrefs;
                if (logger.isFinest()) {
                    logger.finest(m_className, method, "Using WcmPrefObjectStoreView..");
                }
                if ((sitePrefs = (WcmSitePrefs)VWIDMBaseFactory.instance().getProperties().getProperty("sitePreferences")) != null) {
                    WcmObjectStorePrefs osPrefs = sitePrefs.getObjectStorePrefs(this.getLabel());
                    this.m_documentNameProperty = osPrefs.getDocumentNameProperty();
                    if (logger.isFinest()) {
                        logger.finest(m_className, method, "WcmObjectStorePrefs.getDocumentNameProperty() returns " + this.m_documentNameProperty);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.m_documentNameProperty == null) {
            this.m_documentNameProperty = "DocumentTitle";
        }
        return this.m_documentNameProperty;
    }

    protected String getFolderNameProperty() {
        String method = "getFolderNameProperty: " + this.getLabel();
        if (this.m_folderNameProperty == null) {
            try {
                WcmSitePrefs sitePrefs = (WcmSitePrefs)VWIDMBaseFactory.instance().getProperties().getProperty("sitePreferences");
                if (sitePrefs != null) {
                    WcmObjectStorePrefs osPrefs = sitePrefs.getObjectStorePrefs(this.getLabel());
                    this.m_folderNameProperty = osPrefs.getFolderNameProperty();
                    if (logger.isFinest()) {
                        logger.finest(m_className, method, "WcmObjectStorePrefs.getFolderNameProperty() returns " + this.m_folderNameProperty);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.m_folderNameProperty == null) {
            this.m_folderNameProperty = "FolderName";
        }
        return this.m_folderNameProperty;
    }

    protected String getCustomObjectNameProperty() {
        String method = "getCustomObjectNameProperty: " + this.getLabel();
        if (this.m_customObjectNameProperty == null) {
            try {
                WcmSitePrefs sitePrefs = (WcmSitePrefs)VWIDMBaseFactory.instance().getProperties().getProperty("sitePreferences");
                if (sitePrefs != null) {
                    WcmObjectStorePrefs osPrefs = sitePrefs.getObjectStorePrefs(this.getLabel());
                    this.m_folderNameProperty = osPrefs.getCustomObjectNameProperty();
                    if (logger.isFinest()) {
                        logger.finest(m_className, method, "WcmObjectStorePrefs.getCustomObjectNameProperty() returns " + this.m_folderNameProperty);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.m_customObjectNameProperty == null) {
            this.m_customObjectNameProperty = "Name";
        }
        return this.m_customObjectNameProperty;
    }

    public String getLabel() {
        if (this.m_label == null) {
            try {
                this.m_label = this.m_wcmLib.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_label;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   16 Oct 2006 12:42:22  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   lnguyen  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.43  $";
    }
}

